#define OUT_LENGTH_BOUNDED_Z( length )
#define OUT_DATALENGTH_Z 
#define IN_DATALENGTH_MIN( min )
#define IN_ENUM_OPT( name )
#define IN_BUFFER
#define OUT_BUFFER

/*** Declaration of base64encode and base64decode ***/

#define BYTE unsigned char

int base64encode( OUT_BUFFER char *dest,  
                                  IN_DATALENGTH_MIN( 10 ) const int destMaxLen,
                                  OUT_LENGTH_BOUNDED_Z( destMaxLen ) int *destLen,
                                  IN_BUFFER const void *src, 
                                  IN_DATALENGTH_MIN( 10 ) const int srcLen, 
                                  IN_ENUM_OPT( CRYPT_CERTTYPE ) \
                                        const CRYPT_CERTTYPE_TYPE certType );

int base64decode( OUT_BUFFER void *dest,
                                  IN_DATALENGTH_MIN( 10 ) const int destMaxLen,
                                  OUT_DATALENGTH_Z int *destLen,
                                  IN_BUFFER const BYTE *src,
                                  IN_DATALENGTH_MIN( 10 ) const int srcLen, 
                                  IN_ENUM_OPT( CRYPT_CERTFORMAT ) \
                                        const CRYPT_CERTFORMAT_TYPE format );

